﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Security.Principal;
using QuestBack.Integration.SampleClient.QBService; // Namespace given while adding service reference to questback WSDL

namespace QuestBack.Integration.SampleClient
{
    class Start
    {
        public static QuestBackIntegrationLibraryClient QuestbackService = new QuestBackIntegrationLibraryClient();
        public static UserInfo UserInfo = new UserInfo();
        public static Paging PageInfo = new Paging();
        public static QuestInfo QuestInfo = new QuestInfo();

        public static int QuestionId = 0; //Needed for some methods

        static void Main(string[] args)
        {
            // before you start here you need to make sure of following:            
            // You have username and password                        

            UserInfo.Username = ""; //Your integration username here
            UserInfo.Password = ""; // your integration password here
            PageInfo.PageNo = 0;// Page index you want in return starts with 0
            PageInfo.PageSize = 10;//How many rows you want per call (maximum 1000)
            QuestInfo.QuestId = 0; //Need to fill in the correct questId             
            QuestInfo.SecurityLock = ""; //And the correct security id for the quest.


            //Note: Call the required method you want to test
            //some methods need additional information and adjustments
            //First time users might want to create a new quest to play around with. This you need to do in the web application.

            TestConnection();
            //GetQuests();
            //GetQuestions();          
            //GetAnswersToQuestion();
            //GetResponsesToQuest();
            //AddEmailInvitations(); 
            //AddRespondentData();
            //GetInviteeInfo();
            //GetRespondentData();
            //AddRespondentsDataWithoutEmailInvitation();
            //GetReportExport();
            Console.WriteLine(":Finished execution. Press Any key to Close window");
            Console.ReadKey(); //Pause the command window
        }

        //Test that the Username and password is working
        public static void TestConnection()
        {
            string message = QuestbackService.TestConnection(UserInfo);
            Console.WriteLine(message);
        }

        //Get questions for a quest
        public static void GetQuests()
        {
            QuestFilter questFiler = new QuestFilter(); // you can filter based on start date/end date and State of quest
            questFiler.QuestState = "Draft|Active|Scheduled|Closed";//if you only want to see published quest that is live just use "Active". (case sensitive)

            QuestList quests = QuestbackService.GetQuests(UserInfo, PageInfo, questFiler);
            int totalQuests = quests.PageInfo.TotalCount; // this variable contains how many total records found in database based on your searched criteria.

            foreach (var quest in quests.Quests)
            {
                Console.WriteLine(quest.QuestId + ": SecurityLock " + quest.SecurityLock + ":Title: " + quest.QuestTitle);
            }
        }

        // to read questions for given quuest
        public static void GetQuestions()
        {
            QuestQuestion[] questQuestions = QuestbackService.GetQuestQuestions(UserInfo, QuestInfo);

            foreach (var questQuestion in questQuestions)
            {
                Console.WriteLine("QuestionId : " + questQuestion.QuestionId + " order no:" + questQuestion.QuestionNumber + " Type: " + questQuestion.QuestionType);
                if (questQuestion.QuestionTitle.Length > 0) // this is because title can be different for multilingule quests
                    foreach (var questionTitle in questQuestion.QuestionTitle)
                    {
                        Console.WriteLine("Title:" + questionTitle.Title + " language id:" + questionTitle.LanguageId);
                    }
                if (questQuestion.Alternatives.Length > 0) // to read alternatives
                    foreach (var alternativese in questQuestion.Alternatives)
                    {
                        Console.WriteLine("Alternative: " + alternativese.OrderNo + " - " + alternativese.DefaultText);
                    }
                if (questQuestion.SubQuestion != null && questQuestion.SubQuestion.Length > 0) // If question type is matrix or priority then you will get in here.
                {
                    foreach (var question in questQuestion.SubQuestion)
                    {
                        Console.WriteLine("QuestionId : " + question.QuestionId + " order no:" + question.QuestionNumber + " Type: " + question.QuestionType);
                        if (questQuestion.QuestionTitle.Length > 0) // this is because title can be different for multilingule quests
                            foreach (var questionTitle in question.QuestionTitle)
                            {
                                Console.WriteLine("Title:" + questionTitle.Title + " language id:" + questionTitle.LanguageId);
                            }
                        if (questQuestion.Alternatives.Length > 0) // to read alternatives
                            foreach (var alternativese in question.Alternatives)
                            {
                                Console.WriteLine("Alternative: " + alternativese.OrderNo + " : " + alternativese.DefaultText);
                            }
                    }
                }
            }
        }

        // to read answer to given question
        public static void GetAnswersToQuestion()
        {
            var questionId = QuestionId != 0 ? QuestionId : 0;//Question you want get answers for
            if (questionId == 0) Console.WriteLine("You need to set a QuestionId in the method " + System.Reflection.MethodBase.GetCurrentMethod().Name);
            ResponseFilter responseFilter = new ResponseFilter();
            //responseFilter.MailAdress = "test@testback.com"; //If you want to read answers from one respondent
            //responseFilter.FromDate = ""; // start response date
            //responseFilter.ToDate= ""; // Up to response date
            AnswerList answerList = QuestbackService.GetAnswers(UserInfo, QuestInfo, questionId, PageInfo, responseFilter);
            int totalAnswers = answerList.PageInfo.TotalCount;
            foreach (var answer in answerList.Answers)
            {
                Console.WriteLine("Answer= " + answer.Value + " order no= " + answer.OrderNo + " responseid= " + answer.ResponseId);
            }

        }

        // to read complete response to given quest
        public static void GetResponsesToQuest()
        {
            ResponseFilter responseFilter = new ResponseFilter();
            //responseFilter.MailAdress = "test@questback.com"; //If you want to read answers from one respondent
            //responseFilter.FromDate = ""; // start response date
            //responseFilter.ToDate = ""; // Up to response date

            ResponseList responseList = QuestbackService.GetResponses(UserInfo, QuestInfo, PageInfo,
                                                                     responseFilter);
            int totalResponses = responseList.PageInfo.TotalCount;
            foreach (var response in responseList.Responses)
            {
                Console.WriteLine(response.ResponseId + " Date:" + response.Completed);
                foreach (var answer in response.Answers)
                {
                    Console.WriteLine("QuestionId :" + answer.QuestionId + " order no: " + answer.OrderNo + " Text: " +
                                      answer.Value + " Type:" + answer.AnswerType);
                }
            }
        }

        // to add email invitee(s) to quest
        public static void AddEmailInvitations()
        {
            string[] emailArrary = new string[2]; //Array of email addresses max 200
            emailArrary[0] = "email@tesback.com";
            emailArrary[1] = "email2@testback.com";
            string message = QuestbackService.AddEmailInvitees(UserInfo, QuestInfo, emailArrary, true, 0);

            Console.WriteLine(message);
        }

        // to add invitation with respondent data to given quest
        public static void AddRespondentData()
        {
            //create respondent data header Note: this will be used only once for each quest, once header is create this will be ignored
            // here we are creating respondent data header with three columns "Email, Name and Age"
            //Email should be first field
            var respondentDataHeaders = new List<RespondentDataHeader>();
            respondentDataHeaders.Add(new RespondentDataHeader()
            {
                Title = "Email",
                IsEmailField = true,
                Type = RespondentHeaderType.Text
            });

            respondentDataHeaders.Add(new RespondentDataHeader
            {
                Title = "Name",
                IsEmailField = false,
                Type = RespondentHeaderType.Text
            });

            respondentDataHeaders.Add(new RespondentDataHeader
            {
                Title = "Age",
                IsEmailField = false,
                Type = RespondentHeaderType.Numeric
            });


            string[] respondentsArray = new string[1];
            respondentsArray[0] = "test@testback.com;John Doe;31";
            RespondentsData respondentData = new RespondentsData();
            respondentData.AddAsInvitee = true;
            respondentData.AllowDuplicate = true;
            respondentData.RespondentDataHeader = respondentDataHeaders.ToArray();
            respondentData.Delimiter = ";";
            respondentData.DistributionPrioritization = "email";
            respondentData.RespondentData = respondentsArray;
            string message = QuestbackService.AddRespondentsData(UserInfo, QuestInfo, respondentData, 0);
            Console.WriteLine(message);
        }

        // to read information about invitees already added to quests
        public static void GetInviteeInfo()
        {
            InviteeFilter inviteeFilter = new InviteeFilter();
            //lInviteeFilter.HasReplied = BoolFilter.False; //to read all invitees who has not replied to quest
            //lInviteeFilter.OptedOut = BoolFilter.True;//to real all invitees who has opted out from quest
            InviteeList inviteesInfo = QuestbackService.GetInviteesInfo(UserInfo, QuestInfo, PageInfo, inviteeFilter);
            int totalCount = inviteesInfo.PageInfo.TotalCount;
            string defLink = inviteesInfo.DefLink;// this is structure of link (used if you want to send email via your email client.

            foreach (var invitee in inviteesInfo.Inviteess)
            {
                Console.WriteLine(invitee.MailAddress + " : Invited = " + invitee.InvitationSent + " : Has replied=" +
                                  invitee.HasReplied + " : Opted out=" + invitee.OptedOut);
            }
        }

        // to read respondent data added to quest
        public static void GetRespondentData()
        {
            RespondentList respondentsData = QuestbackService.GetRespondentsData(UserInfo, QuestInfo, ";", PageInfo);
            int totalCount = respondentsData.PageInfo.TotalCount;

            Console.WriteLine(respondentsData.RespondentData[0]); //First item in returned item is always respondent data header
            for (int i = 1; i < respondentsData.RespondentData.Length; i++)
                Console.WriteLine(respondentsData.RespondentData[i]);
        }

        //To add respondent data to given quest and get unique invitation link from QuestBack, Note that Questback will NOT send the email invitation if this method is used.
        public static void AddRespondentsDataWithoutEmailInvitation()
        {
            //create respondent data header Note: this will be used only once for each quest, once header is create this will be ignored
            // here we are creating respondent data header with three columns "Email, Name and Age"
            //Email MUST be first field
            var respondentDataHeaders = new RespondentDataHeader[3];
            var respondentDataHeader = new RespondentDataHeader
            {
                Title = "Email",
                IsEmailField = true,
                Type = RespondentHeaderType.Text
            };
            respondentDataHeaders[0] = respondentDataHeader;
            respondentDataHeader = new RespondentDataHeader
            {
                Title = "Name",
                IsEmailField = false,
                Type = RespondentHeaderType.Text
            };
            respondentDataHeaders[1] = respondentDataHeader;

            respondentDataHeader = new RespondentDataHeader
            {
                Title = "Age",
                IsEmailField = false,
                Type = RespondentHeaderType.Numeric
            };
            respondentDataHeaders[2] = respondentDataHeader;
            //respondent data header
            string[] respondentsArray = new string[1];
            respondentsArray[0] = "Jane@testback.com; Jane Doe;21";
            RespondentsData respondentData = new RespondentsData();
            respondentData.AddAsInvitee = true;
            respondentData.AllowDuplicate = true;
            respondentData.RespondentDataHeader = respondentDataHeaders;
            respondentData.Delimiter = ";";
            respondentData.RespondentData = respondentsArray;
            string uniqueInvitationLink = QuestbackService.AddRespondentsDataWithoutEmailInvitation(UserInfo, QuestInfo, respondentData, 0);
            Console.WriteLine(uniqueInvitationLink);
        }



        // to add invitation with respondent data to given quest
        public static void AddRespondentDataWithSmsInvitationOBSOLETE_USE_AddRespondentData()
        {
            //create respondent data header Note: this will be used only once for each quest, once header is create this will be ignored
            // here we are creating respondent data header with three columns "Email,Mobile, Name and Age"
            //Email MUST be first field and Mobile must be second field
            RespondentDataHeader[] respondentDataHeaders = new RespondentDataHeader[4];
            RespondentDataHeader respondentDataHeader = new RespondentDataHeader
            {
                Title = "Epost",
                IsEmailField = true,
                Type = RespondentHeaderType.Text
            };
            respondentDataHeaders[0] = respondentDataHeader;
            respondentDataHeader = new RespondentDataHeader
            {
                Title = "Mobile",
                IsSmsField = true,
                Type = RespondentHeaderType.Text
            };
            respondentDataHeaders[1] = respondentDataHeader;
            respondentDataHeader = new RespondentDataHeader
            {
                Title = "Name",
                Type = RespondentHeaderType.Text
            };
            respondentDataHeaders[2] = respondentDataHeader;

            respondentDataHeader = new RespondentDataHeader
            {
                Title = "Age",
                Type = RespondentHeaderType.Numeric
            };
            respondentDataHeaders[3] = respondentDataHeader;
            //respondent data header
            string[] respondentsArray = new string[1];
            //NOTE:Phone number must start with country prefix
            respondentsArray[0] = "Mary@testback.com;4790197443;Mary Jane;31";
            RespondentsData respondentData = new RespondentsData();
            respondentData.AddAsInvitee = true;
            respondentData.AllowDuplicate = true;
            respondentData.RespondentDataHeader = respondentDataHeaders;
            respondentData.Delimiter = ";";
            respondentData.RespondentData = respondentsArray;

            var smsMessage = "Hello please take few minutes to answer following survey";
            //here you can use respondent data tags if you want to replace in sms invitations for e.g. Hello [!Name!] here [!Name!] will be replaced with actual name you send in the data.
            string message = QuestbackService.AddRespondentsDataWithSmsInvitation(UserInfo, QuestInfo, respondentData, 0, 12345678, "QuestBack", smsMessage);
            Console.WriteLine(message);
        }

        public static void GetReportExport()
        {
            var responseFilter = new ResponseFilter();
            var settings = new ReportExportSettings();
            settings.CsvFieldSeparator = ";";
            settings.ExportType = ExportType.CSV;
            settings.RawDataValue = ExportRawDataValue.Text;
            settings.IncludeEmailOrPhone = true;

            var exportInfo = QuestbackService.GetReportExport(UserInfo, QuestInfo, responseFilter, settings);
            Console.WriteLine(string.Format("GetExportFile: Url for file content: {0}", exportInfo.Link));

            //Replace false with true if you want to store the file to local disk. Default path=c:\temp\myFile.csv
            if (false)
                using (var client = new WebClient())
                {
                    var path = @"c:\temp";
                    var dir = new DirectoryInfo(path);
                    if (!dir.Exists)
                        dir.Create();

                    client.DownloadFile(exportInfo.Link, Path.Combine(path, "myFile.csv"));
                }


        }

    }
}
